﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using AMESDK.NET;

namespace SC5A0
{
    public partial class MyFileManagerControl : UserControl
    {
        public UInt32[] m_pFileInfoList = new UInt32[4];

        UInt64 m_nStartSearchSystemTime = 0;

        UInt64 m_nStopSearchSystemTime = 0;

        UInt64 m_nLastSyncSystemTime = 0;

        Boolean m_bIsExportRangeSelecting = false;

        UInt32 m_nStartExportPoint = 0;

        UInt32 m_nStopExportPoint = 0;
        
        public MyFileManagerControl()
        {
            InitializeComponent();
        }

        public void ExportFileToDisk()
        {
            DateTime s_system_time = DateTime.FromFileTime((long)m_nStartSearchSystemTime);            

            DateTime s_start_search_system_time  =  new DateTime(s_system_time.Year, s_system_time.Month, s_system_time.Day);

            DateTime s_stop_search_system_time = new DateTime(s_system_time.Year, s_system_time.Month, s_system_time.Day, 23, 59, 59, 999);

            UInt64 n_start_search_system_time = (UInt64)s_start_search_system_time.ToFileTimeUtc();

            UInt64 n_stop_search_system_time = (UInt64)s_stop_search_system_time.ToFileTimeUtc();

            UInt64 n_start_export_system_time = (UInt64)(((m_nStartExportPoint * (n_stop_search_system_time - n_start_search_system_time)) / (UInt64)this.ClientRectangle.Width) + n_start_search_system_time);

            UInt64 n_stop_export_system_time = (UInt64)(((m_nStopExportPoint * (n_stop_search_system_time - n_start_search_system_time)) / (UInt64)this.ClientRectangle.Width) + n_start_search_system_time);

            UInt32 i = 0;

            uint nExportProgress = 0;

            uint nAudioEncoder = 0;

            for (i = 0; i < 4; i++  )
            {
                string psz_src = @"C:\SC5A0\CH" + (i + 1).ToString("D2") + "\\";

                string psz_dst = @"C:\BACKUP\" + s_system_time.Year.ToString("D4") +
                                                                         s_system_time.Day.ToString("D2") +
                                                                         s_system_time.Hour.ToString("D2") +
                                                                         s_system_time.Minute.ToString("D2") +
                                                                         s_system_time.Second.ToString("D2") + "\\";

                Directory.CreateDirectory(psz_dst);

                psz_dst = @"C:\BACKUP\" +   s_system_time.Year.ToString("D4") +
                                                                 s_system_time.Month.ToString("D2") +
                                                                 s_system_time.Day.ToString("D2") +
                                                                 s_system_time.Hour.ToString("D2") +
                                                                 s_system_time.Minute.ToString("D2") +
                                                                 s_system_time.Second.ToString("D2") + "\\CH" + (i + 1).ToString("D2") + "\\";

                Directory.CreateDirectory(psz_dst);

                uint pDstFileRenderer = EXPORTS.AMESDK_FILE_EXPORT_START(ref psz_src, ref psz_dst, n_start_export_system_time, n_stop_export_system_time, 1099511627776, ref nExportProgress, ref nAudioEncoder);

                EXPORTS.AMESDK_FILE_EXPORT_STOP(pDstFileRenderer);
            }
        }

        public void EnumFileInfoFromDisk(Boolean bIsInitialize)
        {
            UInt64 n_start_search_system_time = UInt64.MinValue;

            UInt64 n_stop_search_system_time = UInt64.MaxValue;

            DateTime s_system_time = DateTime.Now;

            DateTime s_start_search_system_time = new DateTime(s_system_time.Year, s_system_time.Month, s_system_time.Day);

            DateTime s_stop_search_system_time = new DateTime(s_system_time.Year, s_system_time.Month, s_system_time.Day, 23, 59, 59, 999);

            m_nStartSearchSystemTime = (UInt64)s_start_search_system_time.ToFileTime();

            m_nStopSearchSystemTime = (UInt64)s_stop_search_system_time.ToFileTime();

            m_nLastSyncSystemTime = (UInt64)s_system_time.ToFileTime();

            n_start_search_system_time = (UInt64)s_start_search_system_time.ToFileTimeUtc();

            n_stop_search_system_time = (UInt64)s_stop_search_system_time.ToFileTimeUtc();

            UInt32 i = 0;            

            uint nSearchProgress = 0, nRepairProgress = 0;

            if (bIsInitialize)
            {
                for (i = 0; i < 4; i++)
                {
                    string psz_search_directory = @"C:\SC5A0\CH" + (i + 1).ToString("D2") + "\\";

                    m_pFileInfoList[i] = EXPORTS.AMESDK_FILE_GET_FILE_INFO_LIST(ref psz_search_directory, n_start_search_system_time, n_stop_search_system_time, 0, ref nSearchProgress, ref nRepairProgress); // 18446744073709551615 = &HFFFFFFFFFFFFFFFF
                }
            }
            else
            {
                for (i = 0; i < 4; i++)
                {
                    string psz_search_directory = @"C:\SC5A0\CH" + (i + 1).ToString("D2") + "\\";

                    EXPORTS.AMESDK_FILE_UPDATE_FILE_INFO_LIST(m_pFileInfoList[i], ref psz_search_directory, n_start_search_system_time, n_stop_search_system_time, 0, ref nSearchProgress, ref nRepairProgress); // 18446744073709551615 = &HFFFFFFFFFFFFFFFF
                }
            }

            this.Invalidate();
        }        

        private void MyFileManagerControl_Disposed(object sender, EventArgs e)
        {
            UInt32 i = 0;

            for (i = 0; i < 4; i++ )
            {
                EXPORTS.AMESDK_FILE_FREE_FILE_INFO_LIST( m_pFileInfoList[ i ] );

                m_pFileInfoList[i] = 0;
            }
        }

        private void MyFileManagerControl_Load(object sender, EventArgs e)
        {
            m_bIsExportRangeSelecting = false;

            m_nStartExportPoint = 0;

            m_nStopExportPoint = 0;

            this.DoubleBuffered = true;

            EnumFileInfoFromDisk(true);            
        }

        private void MyFileManagerControl_MouseDown(object sender, MouseEventArgs e)
        {            
             m_nStartExportPoint = (uint)e.X;

            m_nStopExportPoint = (uint)e.X;

            m_bIsExportRangeSelecting = true;

            this.Invalidate();
        }

        private void MyFileManagerControl_MouseUp(object sender, MouseEventArgs e)
        {
            m_nStopExportPoint = (uint)e.X;

            m_bIsExportRangeSelecting = false;

            this.Invalidate();
        }

        private void MyFileManagerControl_MouseMove(object sender, MouseEventArgs e)
        {
            if (m_bIsExportRangeSelecting)
            {
                m_nStopExportPoint = (uint)e.X;

                this.Invalidate();
            }            
        }

        private void MyFileManagerControl_Paint(object sender, PaintEventArgs e)
        {
            // DRAW EXPORT SELECTION BAR (LIGHT BLUE)
            //
            if (m_nStartExportPoint == m_nStopExportPoint)
            {
                UInt32 po_exp = m_nStartExportPoint;

                UInt32 pe_exp = m_nStopExportPoint;

                if (m_nStartExportPoint > m_nStopExportPoint ) { po_exp = m_nStopExportPoint; }

                if (m_nStartExportPoint > m_nStopExportPoint) { pe_exp = m_nStartExportPoint; }

                if (m_nStartExportPoint == m_nStopExportPoint)
                {
                    e.Graphics.FillRectangle(Brushes.Gold, new Rectangle((int)po_exp, 0, (int)(pe_exp - po_exp), this.ClientRectangle.Height));
                }
            }

            // DRAW CURRENT RECORD FILE BAR (GREEN)
            //
            UInt64 n_start_search_system_times = (UInt64)m_nStartSearchSystemTime;

            UInt64 n_stop_search_system_times = (UInt64)m_nStopSearchSystemTime;

            UInt64 n_start_sync_system_time = (UInt64)m_nLastSyncSystemTime;

            UInt64 n_stop_sync_system_time = (UInt64)DateTime.Now.ToFileTime();

            UInt64 po_sync = (UInt64)(((n_start_sync_system_time - n_start_search_system_times) * (UInt64)this.ClientRectangle.Width) / (n_stop_search_system_times - n_start_search_system_times));

            UInt64 pe_sync = (UInt64)(((n_stop_sync_system_time - n_start_search_system_times) * (UInt64)this.ClientRectangle.Width) / (n_stop_search_system_times - n_start_search_system_times) + (1));

            e.Graphics.FillRectangle(Brushes.Green, new Rectangle((int)po_sync, 0, (int)(pe_sync - po_sync), this.ClientRectangle.Height - 2));

            // DRAW OLD RECORD FILES BAR (BLUE) + PLAYBACK LINE (RED)
            //
            UInt32 i = 0;

            UInt32 j = 0;

            for ( i = 0 ; i < 4 ; i++)
            {
                UInt32 counts = 0;

                EXPORTS.AMESDK_FILE_GET_FILE_INFO_LIST_SIZE(m_pFileInfoList[i], ref counts);

                if (counts > 0)
                {
                    for (j = 0; i < counts; i++)
                    {
                        EXPORTS.AMESDK_FILE_INFO s_file_info = new EXPORTS.AMESDK_FILE_INFO();                        

                        EXPORTS.AMESDK_FILE_GET_FILE_INFO_LIST_ELEMENT(m_pFileInfoList[i], j, ref s_file_info);

                        DateTime s_start_record_system_time = DateTime.FromFileTimeUtc((long)s_file_info.m_nFileStartTime );

                        DateTime s_stop_record_system_time = DateTime.FromFileTimeUtc((long)s_file_info.m_nFileStopTime);

                        s_start_record_system_time = new DateTime(s_start_record_system_time.Year, s_start_record_system_time.Month, s_start_record_system_time.Day, s_start_record_system_time.Hour, s_start_record_system_time.Minute, s_start_record_system_time.Second, s_start_record_system_time.Millisecond);

                        s_stop_record_system_time = new DateTime(s_stop_record_system_time.Year, s_stop_record_system_time.Month, s_stop_record_system_time.Day, s_stop_record_system_time.Hour, s_stop_record_system_time.Minute, s_stop_record_system_time.Second, s_stop_record_system_time.Millisecond);

                        UInt64 n_start_record_system_time = (UInt64)s_start_record_system_time.ToFileTime();

                        UInt64 n_stop_record_system_time = (UInt64)s_stop_record_system_time.ToFileTime();

                        UInt64 po_record = 0;

                        UInt64 pe_record = 0;

                        if (n_start_record_system_time < n_start_search_system_times)
                        {
                            po_record = 0;
                        }
                        else
                        {
                            po_record = (UInt64)(((n_start_record_system_time - n_start_search_system_times) * (UInt64)this.ClientRectangle.Width) / (n_stop_search_system_times - n_start_search_system_times));
                        }

                        if (n_stop_record_system_time < n_start_search_system_times)
                        {
                            pe_record = 0;
                        }
                        else
                        {
                            pe_record = (UInt64)(((n_stop_record_system_time - n_start_search_system_times) * (UInt64)this.ClientRectangle.Width) / (n_stop_search_system_times - n_start_search_system_times) + (1));
                        }

                        UInt32 yo = (UInt32)(i * ((this.ClientRectangle.Height - 2) / 4));

                        UInt32 ye = (UInt32)(i * ((this.ClientRectangle.Height - 2) / 4));

                        e.Graphics.FillRectangle(Brushes.Blue, new Rectangle((int)po_record, (int)yo, (int)(pe_record - po_record), (int)ye));
                    }
                }
            }

            // DRAW BOTTOM LINE (BLACK)
            //
            e.Graphics.DrawLine(Pens.Black, 0, this.ClientRectangle.Bottom - 2, this.ClientRectangle.Right, this.ClientRectangle.Bottom - 2);
        }

        protected override void WndProc(ref Message m)
        {
            if (m.Msg == 0x14) // WM_ERASEBKGND
            {
                return;
            }

            base.WndProc(ref m);
        }

        private void Timer_PAINT_Tick_Tick(object sender, EventArgs e)
        {
            this.Invalidate();
        }
    }
}
